//@--------Include Files----------------------------------------------------------
           
#include "colors.inc"
#include "metals.inc"

//@--------Variables--------------------------------------------------------------

#declare ENV_Starfield =on;  //#  displays the starfield backdrop
#declare ENV_Flare     =on;  //#  displays the lens flare (REQUIRES NKflare plugin!)
#declare ENV_Starsystem=on;  //#  displays the planets and star

#declare OBJ_City      =on;  //#  displays the Swaparamans city

#declare SunRot   = < 80, 25, 0>;
#declare SunDist  = 600*y;
#declare SunSize  = 20;
#declare SunPig   = pigment{ color rgb < 1, .5, 0> }
#declare SunPos   = vrotate( SunDist,SunRot );

//@--------Camera-----------------------------------------------------------------

#declare CamPos = < 5, 0,-50>;
#declare CamLook = < 0, 0, 0>;

camera{
  location  CamPos
  look_at   CamLook
}
light_source{ CamPos rgb 1}

//@--------Lighting---------------------------------------------------------------



//@--------Textures---------------------------------------------------------------

#declare Stars =
pigment {
  granite
  color_map {
    [ 0.000  0.250 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
    [ 0.250  0.300 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
    [ 0.300  0.450 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
    [ 0.450  0.500 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
    [ 0.500  0.650 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
    [ 0.650  0.700 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
    [ 0.700  0.850 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
    [ 0.850  0.900 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
    [ 0.900  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
  }
  turbulence 1
  sine_wave
  scale .075
}
#declare Metal =
texture{
  pigment{ color rgb < .85, .85, 1> }
  finish{ F_MetalA }
}
#declare MetalBlue =
texture{
  pigment{ color rgb < .65, .65, 1> }
  finish{ F_MetalA }
}
#declare MetalGreen =
texture{
  pigment{ color rgb < .36, .49, .23> }
  finish{ F_MetalA }
}
#declare MetalBlack =
texture{
  pigment{ rgb .5 }
  finish{ F_MetalA }
}
#declare GlassInt = interior{ ior 1.5 }
#declare GlassBlue =
texture{
  finish{
    ambient .1
    diffuse .6
    reflection .25
    specular 1
    roughness 1/1000
  }
  pigment{ color rgbft < 0.09, 0.55, 1, .8, .1> }
}

#default{ pigment{ rgb 10*x } }

//@--------Object Declares--------------------------------------------------------

//@@---Star System---
#if (World)
  #include "Murasaki.inc"
  #declare System =
  union{
    object{ Genji }
    object{ Chujo }
    object{ Ryozen }
    object{ Suzaku }
    object{ ReefA }
    object{ ReefB }
  }
#end

//@@---City---
//@@@---components---
#declare Airlock =
union{
  union{
    difference{
      cylinder{ < 0, 0, 0>,< 0, 1, 0>,3 }
      torus{ 3.5,1.5 }
    }
    cylinder{ < 0, 0, 0>,< 0,-3, 0>,2 }
    texture{ Metal }
  }
  cylinder{
    < 0, 1, 0>,< 0, 7, 0>,2
    texture{ MetalBlack }
  }
  sphere{
    < 0, 4, 0>,3
    texture{ MetalGreen }
  }
}
#declare Airlock_T =
union{
  union{
    difference{
      cylinder{ < 0, 0, 0>,< 0, 1, 0>,3 }
      torus{ 3.5,1.5 }
    }
    cylinder{ < 0, 0, 0>,< 0,-3, 0>,2 }
    texture{ Metal }
  }
  cylinder{
    < 0, 1, 0>,< 0, 4, 0>,2
    texture{ MetalBlack }
  }
  cylinder{
    <-3, 4, 0>,< 3, 4, 0>,2
    texture{ MetalBlack }
  }
  sphere{
    < 0, 4, 0>,3
    texture{ MetalGreen }
  }
}
#declare Airlock_X =
union{
  union{
    difference{
      cylinder{ < 0, 0, 0>,< 0, 1, 0>,3 }
      torus{ 3.5,1.5 }
    }
    cylinder{ < 0, 0, 0>,< 0,-3, 0>,2 }
    texture{ Metal }
  }
  cylinder{
    < 0, 1, 0>,< 0, 7, 0>,2
    texture{ MetalBlack }
  }
  cylinder{
    <-3, 4, 0>,< 3, 4, 0>,2
    texture{ MetalBlack }
  }
  sphere{
    < 0, 4, 0>,3
    texture{ MetalGreen }
  }
}
#declare Connector =
union{
  union{
    difference{
      cylinder{ < 0, 0, 0>,< 0, 1, 0>,3 }
      torus{ 3.5,1.5 }
    }
    cylinder{ < 0, 0, 0>,< 0,-3, 0>,2 }
    texture{ Metal }
  }
  cylinder{
    < 0, 1, 0>,< 0, 4, 0>,2
    texture{ MetalBlack }
  }
  sphere{
    < 0, 4, 0>,3
    texture{ MetalGreen }
  }
  rotate 180*x
}
#declare LeftConnector =
object{
  Connector
  rotate 90*z
  translate <-4,-4, 0>
}
#declare RightConnector =
object{
  Connector
  rotate -90*z
  translate < 4,-4, 0>
}
#declare SolarPanel =
union{
  merge{
    box{ <-3, .25,-9>,< 3, .5, 9> }
    difference{
      sphere{ < 0, 0, 0>,2 }
      plane{ y,0 }
    }
    union{
      cylinder{ <-3, .5,-9>,<-.25, .5,-9>, .25 }
      cylinder{ <-3, .5, 9>,<-3, .5,-9>, .25 }
      cylinder{ <-.25, .5,-9>,<-.25, .5, 9>, .25 }
      cylinder{ <-.25, .5, 9>,<-3, .5, 9>, .25 }
      sphere{ <-3, .5,-9>, .25 }
      sphere{ <-3, .5, 9>, .25 }
      sphere{ <-.25, .5,-9>, .25 }
      sphere{ <-.25, .5, 9>, .25 }
      
      cylinder{ < 3, .5,-9>,< .25, .5,-9>, .25 }
      cylinder{ < 3, .5, 9>,< 3, .5,-9>, .25 }
      cylinder{ < .25, .5,-9>,< .25, .5, 9>, .25 }
      cylinder{ < .25, .5, 9>,< 3, .5, 9>, .25 }
      sphere{ < 3, .5,-9>, .25 }
      sphere{ < 3, .5, 9>, .25 }
      sphere{ < .25, .5,-9>, .25 }
      sphere{ < .25, .5, 9>, .25 }
    }
    scale 4
    translate -3*y
    texture{ GlassBlue }
    interior{ GlassInt }
    translate 6.001*y
  }
  object{ Connector }
  translate 4*y
}
#declare Habitat =
union{
  union{
    union{
      cylinder{ < 0, 0, 0>,< 0, 1, 0>,5 }
      cylinder{ < 0, 17, 0>,< 0, 18, 0>,5 }
      texture{ Metal }
    }
    union{
      cylinder{ < 0,  1, 0>,< 0, 17, 0>,6 }
      disc{ < 0,  3, 0>, y, 6 }
      disc{ < 0,  5, 0>, y, 6 }
      disc{ < 0,  7, 0>, y, 6 }
      disc{ < 0,  9, 0>, y, 6 }
      disc{ < 0, 11, 0>, y, 6 }
      disc{ < 0, 13, 0>, y, 6 }
      disc{ < 0, 15, 0>, y, 6 }
      texture{ GlassBlue }
    }
    scale 2
    translate 3*y
  }
  object{ Connector }
  translate 4*y
}
#declare SensorWinged =
union{
  union{
    difference{
      intersection{
        cylinder{ < 0,-4, 0>,< 0, 4, 0>,3 }
        cylinder{ < 0, 0,-4>,< 0, 0, 4>,3 }
      }
      box{ <-5,-5,-5>,< 1, 5, 5> }
      translate 6*x
    }
    difference{
      intersection{
        cylinder{ < 0,-4, 0>,< 0, 4, 0>,3 }
        cylinder{ < 0, 0,-4>,< 0, 0, 4>,3 }
      }
      box{ <-1,-5,-5>,< 5, 5, 5> }
      translate -6*x
    }
    scale < 1, 4, 1>
    texture{ GlassBlue }
    translate < 0, 6, 0>
  }
  object{ LeftConnector }
  object{ RightConnector }
  translate 4*y
}
#declare SensorCurved =
union{
  union{
    difference{
      sphere{ < 0, 0, 0>,5 }
      cylinder{ < 0, 0,-10>,< 0, 0, 10>,3 scale < 1, 2, 1> }
      plane{ -x,-1 rotate  45*z }
      plane{ -x,-1 rotate -45*z }
      rotate -20*z
      scale < 2, 3, 1>
      translate <-1,-4, 0>
    }
    difference{
      sphere{ < 0, 0, 0>,5 }
      cylinder{ < 0, 0,-10>,< 0, 0, 10>,3 scale < 1, 2, 1> }
      plane{ x,-1 rotate  45*z }
      plane{ x,-1 rotate -45*z }
      rotate 20*z
      scale < 2, 3, 1>
      translate < 1,-4, 0>
    }
    cylinder{ < 7,-4, 0>,< 9,-4, 0>,2 }
    cylinder{ <-7,-4, 0>,<-9,-4, 0>,2 }
    texture{ Metal }
  }
  object{ LeftConnector }
  object{ RightConnector }
  translate 4*y
  rotate 90*y
}
#declare StorageCylinder =
union{
  merge{
    difference{
      cylinder{ < 0, 1, 0>,< 0, 3, 0>,3.5 }
      box{ <-1, 0,-5>,< 1, 4, 5> }
      texture{ Metal }
    }
    cylinder{
      < 0, 0, 0>,< 0, 1, 0>,3.75
      texture{ MetalBlack }
    }
    cylinder{
      < 0, 1, 0>,< 0, 11, 0>,3
      texture{ GlassBlue }
    }
    scale 3
    translate 3*y
  }
  object{ Connector }
  translate 4*y
}
#declare StorageSphere =
union{
  merge{
    difference{
      sphere{ < 0, 11, 0>,5.5 }
      plane{ -y,-9 }
      box{ <-1, 5,-6>,< 1, 17, 6> }
      texture{ Metal }
    }
    difference{
      sphere{ < 0, 11, 0>,5.75 }
      plane{ -y,-7 }
      texture{ MetalBlack }
    }
    sphere{
      < 0, 11, 0>,5
      texture{ GlassBlue }
    }
    scale 3
    translate -3*y
  }
  object{ Connector }
  translate 4*y
}
//@@@---connector pieces---
#declare Corridor =
union{
  cylinder{
    < 0,-10, 0>,< 0, 10, 0>,2
    texture{ Metal }
  }
  union{
    union{
      difference{
        cylinder{ < 0, 0, 0>,< 0, 1, 0>,3 }
        torus{ 3.5,1.5 }
      }
      cylinder{ < 0, 0, 0>,< 0,-3, 0>,2 }
      texture{ Metal }
    }
    cylinder{
      < 0, 1, 0>,< 0, 4, 0>,2
      texture{ MetalBlack }
    }
    sphere{
      < 0, 4, 0>,3
      texture{ MetalGreen }
    }
    translate 13*y
  }
  union{
    union{
      difference{
        cylinder{ < 0, 0, 0>,< 0, 1, 0>,3 }
        torus{ 3.5,1.5 }
      }
      cylinder{ < 0, 0, 0>,< 0,-3, 0>,2 }
      texture{ Metal }
    }
    cylinder{
      < 0, 1, 0>,< 0, 4, 0>,2
      texture{ MetalBlack }
    }
    sphere{
      < 0, 4, 0>,3
      texture{ MetalGreen }
    }
    translate 13*y
    rotate 180*z
  }
  union{
    cylinder{ <-5, 0, 0>,< 5, 0, 0>,2 }
    cylinder{ < 0, 0,-5>,< 0, 0, 5>,2 }
    box{ <-5,-10,-2>,<-5.5, 10, 2> rotate   0*y }
    box{ <-5,-10,-2>,<-5.5, 10, 2> rotate  90*y }
    box{ <-5,-10,-2>,<-5.5, 10, 2> rotate 180*y }
    box{ <-5,-10,-2>,<-5.5, 10, 2> rotate 270*y }
    texture{ Metal }
  }
}
#declare CorridorUp =
object{
  Corridor
  translate 17*y
  rotate 0*z
}
#declare CorridorRight =
object{
  Corridor
  translate 17*y
  rotate 90*z
}
#declare CorridorLeft =
object{
  Corridor
  translate 17*y
  rotate 270*z
}
#declare CorridorDown =
object{
  Corridor
  translate 17*y
  rotate 180*z
}
#declare CorridorIn =
object{
  Corridor
  translate 17*y
  rotate 90*x
}
#declare CorridorOut =
object{
  Corridor
  translate 17*y
  rotate 270*x
}

//@@@---main assembly---
#declare MainCorridor =
union{
  object{ CorridorLeft translate     0*x}
  object{ CorridorLeft translate    34*x }
  object{ CorridorLeft translate    68*x }
  object{ CorridorLeft translate   102*x }
  object{ CorridorLeft translate   136*x }
  object{ CorridorRight translate    0*x }
  object{ CorridorRight translate  -34*x }
  object{ CorridorRight translate  -68*x }
  object{ CorridorRight translate -102*x }
  object{ CorridorRight translate -136*x }
}
#declare BranchA =
union{
  object{ CorridorUp    translate <  0,  0,  0> }
  object{ CorridorUp    translate <  0, 34,  0> }
  object{ CorridorRight translate <  0, 34,  0> }
  object{ CorridorUp    translate <-34, 34,  0> }
  object{ CorridorRight translate <-34, 34,  0> }
  object{ CorridorLeft  translate <  0, 34,  0> }
  object{ CorridorUp    translate < 34, 34,  0> }
  object{ CorridorLeft  translate < 34, 34,  0> }
}
#declare BranchB =
union{
  object{ CorridorUp    translate <  0,  0,  0> }
  object{ CorridorIn    translate <  0, 34,  0> }
  object{ CorridorOut   translate <  0, 34,  0> }
  object{ CorridorUp    translate <  0, 34,  0> }
  
  object{ CorridorUp    translate <  0, 68,  0> }
  object{ CorridorOut   translate <  0, 68,  0> }
  object{ CorridorUp    translate <  0, 68,-34> }
  object{ CorridorIn    translate <  0, 68,  0> }
  object{ CorridorUp    translate <  0, 68, 34> }
}
#declare BranchC =
union{
  object{ CorridorIn    translate <  0,  0,  0> }
  object{ CorridorUp    translate <  0,  0, 34> }
  object{ CorridorDown  translate <  0,  0, 34> }
  
  object{ CorridorIn    translate <  0,  0, 34> }
  object{ CorridorUp    translate <  0,  0, 68> }
  object{ CorridorDown  translate <  0,  0, 68> }
  
  object{ CorridorIn    translate <  0,  0, 68> }
  object{ CorridorUp    translate <  0,  0, 102> }
  object{ CorridorDown  translate <  0,  0, 102> }
  object{ CorridorIn    translate <  0,  0, 102> }
}
#declare BranchD =
union{
  object{ CorridorUp    translate <  0,  0,  0> }
  object{ CorridorIn    translate <  0, 34,  0> }
  object{ CorridorOut   translate <  0, 34,  0> }
  
  object{ CorridorUp    translate <  0, 34,  0> }
  object{ CorridorIn    translate <  0, 68,  0> }
  object{ CorridorOut   translate <  0, 68,  0> }
  
  object{ CorridorUp    translate <  0, 68,  0> }
  object{ CorridorIn    translate <  0,102,  0> }
  object{ CorridorOut   translate <  0,102,  0> }
  
  object{ CorridorUp    translate <  0,102,  0> }
  object{ CorridorIn    translate <  0,136,  0> }
  object{ CorridorOut   translate <  0,136,  0> }
  object{ CorridorUp    translate <  0,136,  0> }
}
#declare BranchE =
union{
  object{ CorridorUp    translate <  0,  0,  0> }
  object{ CorridorUp    translate <  0, 34,  0> }
  object{ CorridorIn    translate <  0, 68,  0> }
  object{ CorridorLeft  translate <  0, 68,  0> }
  object{ CorridorOut   translate <  0, 68,  0> }
  object{ CorridorUp    translate <  0, 68,  0> }
  
  object{ CorridorDown  translate <  0,  0,  0> }
  object{ CorridorDown  translate <  0,-34,  0> }
  object{ CorridorIn    translate <  0,-68,  0> }
  object{ CorridorLeft  translate <  0,-68,  0> }
  object{ CorridorOut   translate <  0,-68,  0> }
  object{ CorridorDown  translate <  0,-68,  0> }
  
  object{ CorridorIn    translate <  0,  0,  0> }
  object{ CorridorIn    translate <  0,  0, 34> }
  object{ CorridorUp    translate <  0,  0, 68> }
  object{ CorridorLeft  translate <  0,  0, 68> }
  object{ CorridorDown  translate <  0,  0, 68> }
  object{ CorridorIn    translate <  0,  0, 68> }
  
  object{ CorridorOut   translate <  0,  0,  0> }
  object{ CorridorOut   translate <  0,  0,-34> }
  object{ CorridorUp    translate <  0,  0,-68> }
  object{ CorridorLeft  translate <  0,  0,-68> }
  object{ CorridorDown  translate <  0,  0,-68> }
  object{ CorridorOut   translate <  0,  0,-68> }
}
#declare ModuleA =
union{
  object{ SolarPanel rotate   0*z translate <  0, 68,  0> }
  object{ SolarPanel rotate   0*z translate < 34, 68,  0> }
  object{ SolarPanel rotate   0*z translate <-34, 68,  0> }
}
#declare ModuleB =
union{
  object{ StorageCylinder rotate   0*z translate <  0,102,  0> }
  object{ StorageCylinder rotate   0*z translate <  0,102, 34> }
  object{ StorageCylinder rotate   0*z translate <  0,102,-34> }
  
  object{ StorageCylinder rotate  90*x translate <  0, 34, 34> }
  object{ StorageCylinder rotate 270*x translate <  0, 34,-34> }
}
#declare ModuleC =
union{
  object{ StorageSphere rotate   0*x translate <  0, 34, 34> }
  object{ StorageSphere rotate   0*x translate <  0, 34, 68> }
  object{ StorageSphere rotate   0*x translate <  0, 34,102> }
  
  object{ StorageSphere rotate 180*x translate <  0,-34, 34> }
  object{ StorageSphere rotate 180*x translate <  0,-34, 68> }
  object{ StorageSphere rotate 180*x translate <  0,-34,102> }
  
  object{ StorageSphere rotate  90*x translate <  0,  0,136> }
}
#declare ModuleD =
union{
  object{ Habitat rotate  90*x translate <  0, 34, 34> }
  object{ Habitat rotate  90*x translate <  0, 68, 34> }
  object{ Habitat rotate  90*x translate <  0,102, 34> }
  object{ Habitat rotate  90*x translate <  0,136, 34> }
  
  object{ Habitat rotate 270*x translate <  0, 34,-34> }
  object{ Habitat rotate 270*x translate <  0, 68,-34> }
  object{ Habitat rotate 270*x translate <  0,102,-34> }
  object{ Habitat rotate 270*x translate <  0,136,-34> }
  
  object{ Habitat rotate   0*x translate <  0,170,  0> }
}
#declare ModuleE =
union{
  object{ SensorWinged rotate <  0, 90,  0> translate <  0, 102,   0> }
  object{ SensorWinged rotate < 90,  0, 90> translate <  0,   0, 102> }
  object{ SensorWinged rotate <180, 90,  0> translate <  0,-102,   0> }
  object{ SensorWinged rotate <270,  0, 90> translate <  0,   0,-102> }
  
  object{ SensorWinged rotate <  0, 90,270> translate < 34, 68,  0> }
  object{ SensorWinged rotate <  0,  0,270> translate < 34,  0, 68> }
  object{ SensorWinged rotate <  0, 90,270> translate < 34,-68,  0> }
  object{ SensorWinged rotate <  0,  0,270> translate < 34,  0,-68> }
  
  object{ SensorCurved rotate <  0,  0,  0> translate <  0, 34,-68> }
  object{ SensorCurved rotate < 90,  0,  0> translate <  0, 68, 34> }
  object{ SensorCurved rotate <180,  0,  0> translate <  0,-34, 68> }
  object{ SensorCurved rotate <270,  0,  0> translate <  0,-68,-34> }
  
  object{ SensorCurved rotate <  0,  0,  0> translate <  0, 34, 68> }
  object{ SensorCurved rotate < 90,  0,  0> translate <  0,-68, 34> }
  object{ SensorCurved rotate <180,  0,  0> translate <  0,-34,-68> }
  object{ SensorCurved rotate <270,  0,  0> translate <  0, 68,-34> }
}

#declare SectionA =
union{
  object{ BranchA }
  object{ ModuleA }
  object{ BranchA rotate  90*x }
  object{ ModuleA rotate  90*x }
  object{ BranchA rotate 180*x }
  object{ ModuleA rotate 180*x }
  object{ BranchA rotate 270*x }
  object{ ModuleA rotate 270*x }
}
#declare SectionB =
union{
  object{ BranchB }
  object{ ModuleB }
  object{ BranchB rotate 180*x }
  object{ ModuleB rotate 180*x }
}
#declare SectionC =
union{
  object{ BranchC }
  object{ ModuleC }
  object{ BranchC rotate 180*x }
  object{ ModuleC rotate 180*x }
}
#declare SectionD =
union{
  object{ BranchD }
  object{ ModuleD }
  object{ BranchD rotate 180*x }
  object{ ModuleD rotate 180*x }
}
#declare SectionE =
union{
  object{ BranchE }
  object{ ModuleE }
}
#declare City =
union{
  object{ MainCorridor }
  object{ SectionA translate -136*x }
  object{ SectionB translate -68*x }
  object{ SectionC translate   0*x }
  object{ SectionD translate  68*x }
  object{ SectionE translate  136*x }
}

//@--------Objects----------------------------------------------------------------

#declare CityDist = -625;
#if(OBJ_City)
  object{
    City
    rotate 10*-y
    scale .075
    translate CityDist*z
    rotate < 0, 21.5, 0>
    rotate <-15.25, 0,-10>
    translate SunPos
  }
#end

//@--------Environment------------------------------------------------------------

background{ rgb 0 }

#if(ENV_Starfield)
  sky_sphere{ pigment{ Stars } }
#end

#if(ENV_Starsystem)
  object{ System }
#end

union{
  light_source{ SunPos rgb 1 }
  sphere{
    vrotate( SunDist+y,SunRot),SunSize
    pigment{ SunPig }
    finish{ ambient 1 diffuse 0 }
  }
}

#if(ENV_Flare)
  #declare cam_loc = CamPos;
  #declare light_loc = SunPos;
  #declare lookat = CamLook;
  #declare sky_vect = y;
  #include "50mm.flr"
  #include "nkflare.inc" 
#end

//@-------------------------------------------------------------------------------
